<?php include'config.php';?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  
  <title><?= $meta_title ?></title>
  <!-- Plugins CSS -->
  <link href="css/plugins.css" rel="stylesheet">
  <link href="css/jquery-ui.css" rel="stylesheet">
  

  <!-- Custom CSS -->  
  <link href="css/style.css" rel="stylesheet">
  <!-- Favicon -->
  <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
 
</head>

<body>
  <!-- Pre Loader -->
  <div id="dvLoading"></div>
  <!-- Navigation Start -->
  <nav id="navbar" class="navbar fixed-top navbar-expand-lg navbar-header navbar-mobile">
    <div class="navbar-container container">

      <div class="navbar-brand">
        <a class="navbar-brand-logo" href="#top">
          <img src="images/logo.png" alt="logo">
        </a>
      </div>
      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav"
        aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
        <i class="fas fa-bars"></i>
      </button>
      <div class="collapse navbar-collapse justify-content-around" id="navbarNav">
        <ul class="navbar-nav menu-navbar-nav">
          <li class="nav-item">
            <a class="nav-link" href="#top"><i class="fas fa-home"></i> Home</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#calculator"><i class="fas fa-calculator"></i> Calculator</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#services"><i class="fas fa-dollar-sign"></i> Services</a>
          </li>
          <!-- <li class="nav-item">
            <a class="nav-link" href="#blog"><i class="far fa-newspaper"></i> Blog</a>
          </li> -->
          <li class="nav-item">
            <a class="nav-link" href="#reviews"><i class="far fa-comment-dots"></i> Reviews</a>
          </li>
        </ul>
        <ul class="navbar-nav">
          <li class="nav-item">
            <a class="nav-link learn-more-btn" href="#contact">Contact</a>
          </li>
        </ul>
      </div>
    </div>
  </nav>
  <!-- Navigation End -->

  <!-- Banner Start -->
  <div id="top" class="header">
    <div class="container header-container">
      <div class="d-none d-lg-block col-lg-6  header-img-section">
        <img src="images/banner.svg" class="img-fluid" alt="banner">
      </div>
      <div class="col-lg-5 offset-lg-1 col-sm-12 header-title-section">
        <p class="header-subtitle">Loan EMI Calculator</p>
        <h1 class="header-title">A personal loan for multiple purposes!</h1>
        <p class="header-title-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut quis vestibulum ante,
          id gravida sem. Nam dictum ornare dictum. Sed congue accumsan arcu quis consectetur.</p>
        <div class="learn-more-btn-section">
          <a class="nav-link learn-more-btn btn-invert" href="#services">Learn More</a>
        </div>
      </div>
    </div>
  </div>
  <!-- Banner End -->

  <!-- calculator Start -->
  <section id="calculator" class="calculator-section">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <h2 class="section-heading">Loan Calculator</h2>
          <p class="section-para">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas odio sem, tempor
            egestas libero at, fermentum posuere quam. Vestibulum dapibus vulputate sapien. Donec pulvinar libero at ex
            tristique commodo.</p>
        </div>
      </div>
      <div class="row">
        <div class="col-lg-4">
          <form class="form-calculator">
            <div class="form-group">
              <label for="amount">Loan Amount:</label>
              <div class="input-group mb-4">
                <div class="input-group-prepend">
                  <div class="input-group-text">$</div>
                </div>
                <input type="text" class="form-control" id="amount" value="100000">
              </div>
              <div id="slider" class="emi-input"></div>
            </div>

            <div class="form-group">
              <label for="amount">Interest Rate :</label>
              <div class="input-group mb-4">
                <div class="input-group-prepend">
                  <div class="input-group-text">%</div>
                </div>
                <input type="text" class="form-control" id="interest" value="10.5">
              </div>
              <div id="slider-interest" class="emi-input"></div>
            </div>

            <div class="form-group">
              <label for="amount">Loan Tenure :</label>
              <div class="input-group mb-4">
                <div class="input-group-prepend">
                  <div class="input-group-text">Months</div>
                </div>
                <input type="text" class="form-control" id="tenure" value="36">
              </div>
              <div id="slider-tenure" class="emi-input"></div>
            </div>

          </form>
        </div>
        <div class="col-lg-4">
          <div class="emi-details">
            <div class="emi-details-head">
              <h3>Your EMI Details</h3>
            </div>
            <div class="emi-details-box">
              <p>Loan EMI</p>
              <h5>$5247</h5>
            </div>
            <div class="emi-details-box">
              <p>Total Interest Payable</p>
              <h5>$52470</h5>
            </div>
            <div class="emi-details-box no-bottom-border">
              <p>Total Payment</p>
              <h5>$152470</h5>
            </div>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="pie-chart">
            <div id="donutMorris"></div>
            <span class="chart-principal"> Principal Amount</span>
            <span class="chart-interest"> Interest Amount</span>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- calculator End -->

  <!-- services Start -->
  <section id="services" class="services-section">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <h2 class="section-heading">Our Services</h2>
          <p class="section-para">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas odio sem, tempor
            egestas libero at, fermentum posuere quam. Vestibulum dapibus vulputate sapien. Donec pulvinar libero at ex
            tristique commodo.</p>
        </div>
      </div>
      <div class="row">
        <?php 
        $sql = mysqli_query($conn,"select * from $tblService")or die(mysqli_error($conn));
        while($row = mysqli_fetch_assoc($sql)){
        ?>
        <div class="col-lg-4 col-sm-6">
          <div class="service-box">
            <div class="service-icon">
              <img src="../media/image/<?= $row['image1'] ?>" alt="icon">
            </div>
            <div class="service-text">
              <h3 class="service-heading"><?= $row['name'] ?></h3>
              <p class="service-para"><?= $row['short_description'] ?></p>
            </div>

          </div>
        </div>
        <?php }?>
      </div>
    </div>
  </section>
  <!-- services End -->

  <!-- Blog Start -->
  <!-- <section id="blog" class="blog-section">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <h2 class="section-heading">Latest Blog</h2>
          <p class="section-para">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas odio sem, tempor
            egestas libero at, fermentum posuere quam. Vestibulum dapibus vulputate sapien. Donec pulvinar libero at ex
            tristique commodo.</p>
        </div>
      </div>
      <div class="row">
        <div class="col-lg-4 col-sm-6">
          <div class="blog-box">
            <div class="blog-img">
              <img src="images/blog/blog-1.jpg" class="img-fluid" alt="blog">
            </div>
            <div class="blog-text">
              <div class="tags"><span>Personal Loan</span><span>Easy Money</span></div>
              <h3 class="blog-heading">Maecenas odio sem, tempor egestas</h3>
              <p class="blog-para">Lorem ipsum dolor sit amet, consectetur adipiscing elit. libero at, fermentum posuere
                quam.</p>
            </div>
          </div>
        </div>
        <div class="col-lg-4 col-sm-6">
          <div class="blog-box">
            <div class="blog-img">
              <img src="images/blog/blog-2.jpg" class="img-fluid" alt="blog">
            </div>
            <div class="blog-text">
              <div class="tags"><span>Personal Loan</span><span>Easy Money</span></div>
              <h3 class="blog-heading">Maecenas odio sem, tempor egestas</h3>
              <p class="blog-para">Lorem ipsum dolor sit amet, consectetur adipiscing elit. libero at, fermentum posuere
                quam.</p>
            </div>
          </div>
        </div>
        <div class="col-lg-4 d-none d-lg-block">
          <div class="blog-box">
            <div class="blog-img">
              <img src="images/blog/blog-3.jpg" class="img-fluid" alt="blog">
            </div>
            <div class="blog-text">
              <div class="tags"><span>Personal Loan</span><span>Easy Money</span></div>
              <h3 class="blog-heading">Maecenas odio sem, tempor egestas</h3>
              <p class="blog-para">Lorem ipsum dolor sit amet, consectetur adipiscing elit. libero at, fermentum posuere
                quam.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section> -->
  <!-- Blog End -->

  <!-- reviews Start -->
  <section id="reviews" class="reviews-section">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <h2 class="section-heading">Customer Stories</h2>
        </div>
      </div>
      <div class="row">        
        <div class="col-lg-7">          
          <div class="owl-carousel">
            <?php 
        $sql = mysqli_query($conn,"select * from $tblTestimonial")or die(mysqli_error($conn));
        while($row = mysqli_fetch_assoc($sql)){
        ?>
            <div class="review-item">
              <div class="review-details"><i class="fas fa-quote-left"></i> 
                <?= $row['description'] ?>
              </div>
              <div class="review-author">
                <span class="review-img"><img src="../media/image/<?= $row['image1'] ?>" alt="uesr" /></span>
                <span class="review-name"><?= $row['name'] ?></span>
                <span class="review-desig">(<?= $row['heading'] ?>)</span>
              </div>
            </div>
          <?php }?>  
          </div>
        </div>
        <div class="col-lg-4 offset-lg-1 d-none d-lg-block">
          <img src="images/review.svg" class="img-fluid" alt="review" />
        </div>
      </div>
    </div>
  </section>
<!-- reviews End -->

<!-- contact Start -->
  <section id="contact" class="contact-section">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <h2 class="section-heading">Get In Touch</h2>
          <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. libero at, fermentum posuere quam.</p>
        </div>
      </div>
      <div class="row">
        <div class="col-lg-6 d-none d-lg-block">
          <img src="images/contact.svg" class="img-fluid" alt="blog">
        </div>
        <div class="col-lg-6">
          <form class="contact-form" id="frmenquiry">
            <div class="contact-form-head">
              <h3>Send Message</h3>
            </div>
          
            <div class="contact-form-inner">
              <input type='hidden' name="action" value='addEnquiry'>
              <div class="form-group">
                <input type="text" class="form-control" name="name" placeholder="Name">
              </div>
              <div class="form-group">
                <input type="number" class="form-control" name="phone" placeholder="Phone">
              </div>
              <div class="form-group">
                <textarea class="form-control" name="message" placeholder="Write Your Message"></textarea>
              </div>
              <button type="submit" class="btn btn-primary">Submit</button>
              
            </div>
          </form>
        </div>
      </div>
    </div>
  </section>
<!-- contact End -->

<!-- footer Start -->
<section class="footer">
    <div class="container">
      <div class="row">
        <div class="col-lg-3 col-md-6">
          <div class="footer-widget">
            <img src="images/logo-white.png" alt="logo" />
            <p class="mt-4">Lorem ipsum dolor sit amet, consectetur adipiscing elit. libero at, fermentum posuere quam.
            </p>
          </div>
        </div>
        <div class="col-lg-3 col-md-6">
          <div class="footer-widget">
            <h5>Quick Links</h5>
            <ul>
              <li><a href="#"><i class="fas fa-angle-right"></i> Services</a></li>
              <li><a href="#"><i class="fas fa-angle-right"></i> Calculator</a></li>
              <li><a href="#"><i class="fas fa-angle-right"></i> Contact Us</a></li>
              <li><a href="#"><i class="fas fa-angle-right"></i> Reviews</a></li>
            </ul>
          </div>
        </div>
        <div class="col-lg-3 col-md-6">
          <div class="footer-widget">
            <h5>Address</h5>
            <p class="mt-3"><i class="fas fa-map-marker-alt"></i> <?= $address1 ?><br>
              Agra<br>
               <i class="fas fa-mobile-alt"></i> <?= $phone1 ?><br>
               <i class="fas fa-envelope"></i> <?= $email1 ?></p>
          </div>
        </div>
        <div class="col-lg-3 col-md-6">
          <div class="footer-widget">
            <h5>Social Connect</h5>
            <div class="social-icons">
              <a href="<?= $facebook ?>"><i class="fab fa-facebook"></i></a>
              <a href="<?= $twitter ?>"><i class="fab fa-twitter"></i></a>
              <a href="<?= $youtube ?>"><i class="fab fa-linkedin"></i></a>
              <a href="<?= $instagram ?>"><i class="fab fa-instagram"></i></a>
            </div>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-lg-12">
          <div class="footer-copyright">
            © 2020 KonnectCode All Rights Reserved.
          </div>
        </div>
      </div>
    </div>
</section>
<!-- footer End -->

<!-- jQuery Min JS -->
<script src="js/jquery-min.js"></script>
<script src="js/jquery-ui.js"></script>
<script src="js/jquery.ui.touch-punch.min.js"></script>

<!-- Popper Min JS -->
<script src="js/popper.min.js"></script>
<!-- Bootstrap Min JS -->
<script src="js/bootstrap.min.js"></script>
<!-- Owl Carousel Min JS -->
<script src="js/owl.carousel.min.js"></script>
<!-- Owl Plugins JS -->
<script src="js/plugins.js"></script>
<!-- Smooth scroll JS -->
<script src="js/smoothscroll.js"></script>

<!-- morris charts -->
<script src="js/raphael-min.js"></script>
<script src="js/morris.min.js"></script>
<script src="js/custom-morris.js"></script>

<!-- Custom JS -->
<script src="js/custom.js"></script>
<script src="function/custum.js"></script>
</body>


<!-- Mirrored from www.konnectplugins.com/loanica/ by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 26 Aug 2023 07:03:48 GMT -->
</html>
